/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.jei.ingredient.mob;

import com.almostreliable.summoningrituals.compat.jei.ingredient.mob.MobIngredient;
import com.almostreliable.summoningrituals.util.GameUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.TooltipFlag;

public class MobRenderer
implements IIngredientRenderer<MobIngredient> {
    private static final float CREEPER_HEIGHT = 1.7f;
    private static final float CREEPER_SCALE = 0.5f;
    private final Minecraft mc = Minecraft.m_91087_();
    private final EntityRenderDispatcher entityRenderer = this.mc.m_91290_();
    private final int size;

    public MobRenderer(int size) {
        this.size = size;
    }

    public void render(PoseStack stack, @Nullable MobIngredient mob) {
        Entity entity;
        if (this.mc.f_91073_ == null || this.mc.f_91074_ == null || mob == null) {
            return;
        }
        if (mob.getEntity() != null && (entity = mob.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            stack.m_85836_();
            entity2.f_19797_ = this.mc.f_91074_.f_19797_;
            stack.m_85837_((double)(0.5f * (float)this.size), (double)(0.9f * (float)this.size), 0.0);
            float entityHeight = entity2.m_20206_();
            float entityScale = Math.min(1.7f / entityHeight, 1.0f);
            float scaleFactor = 0.5f * (float)this.size * entityScale;
            this.renderEntity(stack, entity2, scaleFactor);
            stack.m_85849_();
        }
        if (mob.getCount() > 1) {
            String count = String.valueOf(mob.getCount());
            GameUtils.renderCount(stack, count, this.size, this.size);
        }
    }

    private void renderEntity(PoseStack stack, LivingEntity entity, float scaleFactor) {
        PoseStack modelView = RenderSystem.m_157191_();
        modelView.m_85836_();
        modelView.m_166854_(stack.m_85850_().m_85861_());
        InventoryScreen.m_98850_((int)0, (int)0, (int)((int)scaleFactor), (float)75.0f, (float)-20.0f, (LivingEntity)entity);
        modelView.m_85849_();
        RenderSystem.m_157182_();
    }

    public List<Component> getTooltip(MobIngredient mob, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(mob.getDisplayName());
        if (tooltipFlag.m_7050_()) {
            tooltip.add((Component)mob.getRegistryName().m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public int getWidth() {
        return this.size;
    }

    public int getHeight() {
        return this.size;
    }
}

